<?php

namespace Inside\Console\Commands;

use Illuminate\Filesystem\Filesystem;
use Inside\Application;
use Inside\Console\Command;

class RouteClearCommand extends Command
{
    protected $name = 'inside:route:clear';

    protected $description = 'Suppression du cache des routes';

    /** @var Application */
    protected $laravel;

    /**
     * @param Filesystem $files
     */
    public function __construct(
        protected Filesystem $files
    ) {
        parent::__construct();
    }

    public function handle(): void
    {
        $this->files->delete($this->laravel->getCachedRoutesPath());

        $this->info('Le cache des routes est correctement supprimé!');
    }
}
