<?php

namespace Inside\Console\Commands;

use Illuminate\Support\Facades\View;
use Inside\Console\Command;
use Inside\Facades\Package;

class PackageListCommand extends Command
{
    protected $signature = 'inside:package:list';

    protected $description = 'La liste des packages et leur version';

    public function handle(): void
    {
        $this->table(
            ['Package', 'Version', 'Type'],
            collect(Package::list())->map(
                function ($package, $name) {
                    return [$name, $package->getVersion(), $package->getType()];
                }
            )
        );

        $this->table(
            ['View customs'],
            collect(View::getFinder()->getPaths())->map(
                function ($path) {
                    return [$path];
                }
            )
        );

        $this->table(
            ['Database migrations'],
            collect(app('migrator')->paths())->map(
                function ($path) {
                    return [$path];
                }
            )
        );
    }
}
