<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;
use Inside\Facades\Package;

class MenusLinkCommand extends Command
{
    protected $signature = 'menus:link';

    protected $description = 'Create a symbolic link from "public/menus" to "storage/app/menus"';

    public function handle(): void
    {
        if (file_exists(cms_base_path('menus'))) {
            $this->error('The "public/menus" directory already exists.');

            return;
        }
        $menusDirectory = storage_path('app/menus');
        if (($storageAppPath = config('app.app_storage_path')) !== null) {
            $menusDirectory = cms_base_path($storageAppPath.'/menus');
        }
        if (! file_exists($menusDirectory)) {
            $this->laravel->make('files')->makeDirectory($menusDirectory);
        }
        $this->laravel->make('files')->link(
            $menusDirectory,
            cms_base_path('menus')
        );
        $this->info('The [public/menus] directory has been linked.');
    }
}
