<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;
use Inside\Facades\ExportImport;

class ImportLayoutCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:layout:import';

    /**
     * @var string
     */
    protected $signature = 'inside:layout:import';

    /**
     * @var string
     */
    protected $description = 'Import layout';

    public function handle(): void
    {
        $this->writeln('<fg=green>Import of layouts</fg=green>');

        /** @var string $layouts */
        $layouts = file_get_contents(cms_base_path('layouts.json'));
        $layouts = collect(json_decode($layouts));

        ExportImport::importLayouts($layouts);
    }
}
