<?php

namespace Inside\Console\Commands;

use Illuminate\Support\Facades\File;
use Inside\Console\Command;
use Inside\Layout\Models\Layout;

class ExportLayoutCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:layout:export';

    /**
     * @var string
     */
    protected $signature = 'inside:layout:export';

    /**
     * @var string
     */
    protected $description = 'Export layout';

    public function handle(): void
    {
        $this->writeln('<fg=green>Export des layouts</fg=green>');

        $layouts = Layout::with('paths')->get()->toJson();
        File::put(cms_base_path('layouts.json'), $layouts);

        $this->write('<fg=magenta>The layouts have been exported here : '.cms_base_path('layouts.json').'</fg=magenta>');
    }
}
