<?php

namespace Inside\Console\Commands;

use Exception;
use Illuminate\Support\InteractsWithTime;
use Inside\Console\Command;
use Inside\Events\InsideIsGoingDown;

class DownCommand extends Command
{
    use InteractsWithTime;

    protected $signature = 'inside:down {--message= : Le message affiché sur la page de maintenance}
                                 {--retry= : Le nombre de secondes indicatif sur la durée de la maintenance}';

    protected $description = 'Mettre le site en mode full maintenance';

    public function handle(): int
    {
        try {
            if (file_exists(storage_path('framework/inside_down'))) {
                $this->comment('Inside est déjà en mode maintenance');

                return Command::SUCCESS;
            }
            InsideIsGoingDown::dispatch();

            file_put_contents(
                storage_path('framework/inside_down'),
                json_encode(
                    $this->getDownFilePayload(),
                    JSON_PRETTY_PRINT
                )
            );

            $this->comment('Inside est désormais en mode maintenance.');

            return Command::SUCCESS;
        } catch (Exception $e) {
            $this->error('Inside a échoué à entrer en mode maintenance.');

            $this->error($e->getMessage());

            return Command::FAILURE;
        }
    }

    protected function getDownFilePayload(): array
    {
        return [
            'time' => $this->currentTime(),
            'message' => $this->option('message'),
            'retry' => $this->getRetryTime(),
        ];
    }

    protected function getRetryTime(): ?int
    {
        $retry = $this->option('retry');

        return is_numeric($retry) && $retry > 0 ? (int) $retry : null;
    }
}
