<?php

namespace Inside\Console;

use Closure;
use Inside\Console\Command;
use ReflectionException;
use ReflectionFunction;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ClosureCommand extends Command
{
    /**
     * Create a new command instance.
     */
    public function __construct(
        string $signature,
        protected Closure $callback
    ) {
        $this->signature = $signature;
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws ReflectionException
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $inputs = array_merge($input->getArguments(), $input->getOptions());

        $parameters = [];

        foreach ((new ReflectionFunction($this->callback))->getParameters() as $parameter) {
            if (isset($inputs[$parameter->name])) {
                $parameters[$parameter->name] = $inputs[$parameter->name];
            }
        }

        return (int) $this->laravel->call(
            /** @phpstan-ignore-next-line */
            $this->callback->bindTo($this, $this),
            $parameters
        );
    }

    /**
     * set purpose of the command
     */
    public function purpose(string $description): static
    {
        return $this->describe($description);
    }

    /**
     * Set the description for the command.x
     */
    public function describe(string $description): static
    {
        $this->setDescription($description);

        return $this;
    }
}
