<?php

use Illuminate\Support\Facades\Broadcast;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\Schema;

// Birthday wished
Broadcast::channel(
    'inside.birthday.{userUuid}',
    function ($user, $userUuid) {
        return $user->uuid === User::findOrNew($userUuid)->uuid;
    }
);

// Comment created
Broadcast::channel(
    'inside_content.{contentType}.{contentUuid}',
    function ($user, $contentType, $contentUuid) {
        if (! Schema::hasContentType($contentType)) {
            return false;
        }

        return call_user_func(type_to_class($contentType).'::find', $contentUuid) !== null;
    }
);

// Content created/deleted/updated by $user
Broadcast::channel(
    'inside.contents.{userUuid}',
    function ($user, $userUuid) {
        return $user->uuid === $userUuid;
    }
);

// Same but only for contentType
Broadcast::channel(
    'inside.contents.{contentType}.{userUuid}',
    function ($user, $contentType, $userUuid) {
        return $user->uuid === $userUuid;
    }
);

// Export content
Broadcast::channel(
    'inside.exports.{userUuid}',
    function ($user, $userUuid) {
        return $user->uuid === $userUuid;
    }
);

// Revision
Broadcast::channel('inside.revisions.{userUuid}', fn ($user, $userUuid) => $user->uuid === $userUuid);
Broadcast::channel('inside.revisions', fn ($user, $type, $uuid) => $user->hasAnyRole('super_administrator'));

// Inside mini chat
Broadcast::channel(
    'inside.chat',
    function ($user) {
        if (is_maecia_admin($user->uuid)) {
            return [
                'uuid'      => $user->uuid,
                'email'     => $user->email,
                'firstname' => $user->information->firstname,
                'lastname'  => $user->information->lastname,
            ];
        }
    }
);
