<?php

declare(strict_types=1);

namespace Inside\Content\Validation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\MessageBag;
use Illuminate\Validation\Rule as LaravelRule;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Facades\Schema;
use Inside\Validation\Validator;
use JsonException;

final class SectionRule implements Rule
{
    /**
     * TODO: this type makes no sense, message bag, null, array and string
     * @var MessageBag
     */
    protected $errors = null;

    protected function makeInsideValidator(
        array $data,
        array $rules,
        array $messages = [],
        array $customAttributes = []
    ): Validator {
        $factory = App::make('validator');
        $factory->resolver(
            function ($translator, $data, $rules, $messages, $customAttributes) {
                return new Validator($translator, $data, $rules, $messages, $customAttributes);
            }
        );

        return $factory->make(
            $data,
            $rules,
            $messages,
            $customAttributes
        );
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value): bool
    {
        $passes = true;
        $this->errors = [];
        $sectionTypes = Schema::getSectionTypes();
        foreach ($value as $key => $sectionData) {
            $type = $sectionData['bundle'];
            $insideValidator = $this->makeInsideValidator(
                $sectionData,
                array_merge(ContentHelper::makeRules($type), [
                    'pgID' => ['uuid', 'nullable'],
                    'bundle' => ['required', LaravelRule::in($sectionTypes)],
                ]),
                [],
                ContentHelper::getAttributeNames($type)
            );
            if ($insideValidator->fails()) {
                if (isset($sectionData['pgID'])) {
                    $key = $sectionData['pgID'];
                } elseif (Request::has($attribute)) {
                    $requestData = Request::get($attribute);
                    if (is_array($requestData)
                        && isset($requestData[$key])
                        && is_array($requestData[$key])
                        && isset($requestData[$key]['pgID'])
                        && is_string($requestData[$key]['pgID'])
                        && str_starts_with($requestData[$key]['pgID'], '_')
                    ) {
                        $key = $requestData[$key]['pgID'];
                    }
                }
                $this->errors[$sectionData['pgID'] ?? $key] = $insideValidator->errors();

                $passes = false;
            }
        }

        return $passes;
    }

    public function message(): string
    {
        try {
            return json_encode($this->errors, JSON_THROW_ON_ERROR);
        } catch (JsonException) {
            return '';
        }
    }
}
