<?php

namespace Inside\Content\Services;

use Inside\Content\Facades\Schema;
use Inside\Content\Models\WysiwygImage;
use Inside\Content\Services\WysiwygImage as WysiwygImageService;

class WysiwygImageTranslatorService
{
    public function __construct(private WysiwygImageService $wysiwygImageService)
    {
    }

    public function execute(): void
    {
        WysiwygImage::all()->each(function ($wysiwygImage) {
            $class = $wysiwygImage->imageable_type;
            if (is_null($class) || ! Schema::isContentType($class)) {
                return;
            }

            $content = $class::where('uuid', $wysiwygImage->imageable_id)->first();
            if (is_null($content)) {
                return;
            }

            $translatedContents = $class::where([
                'uuid_host' => $content->uuid_host,
                'status' => 1,
            ])
                ->where('uuid', '<>', $content->uuid)
                ->get();

            if ($translatedContents->isEmpty()) {
                return;
            }
            $translatedContents->each(fn ($contentDestination) => $this->wysiwygImageService->translate(
                contentSource: $content,
                contentDestination: $contentDestination,
                wysiwygImage: $wysiwygImage
            ));
        });
    }
}
