<?php

namespace Inside\Content\Services\Stocks;

use GuzzleHttp\Client;
use Illuminate\Support\Arr;
use Inside\Content\Contracts\Alphavantage;

class AlphavantageService implements Alphavantage
{
    private ?Client $client = null;

    private function getClient(): Client
    {
        return $this->client ??= new Client(['base_uri' => config('alphavantage.api_uri')]);
    }

    public function getGlobalQuote(string $symbol): ?array
    {
        $response = $this->getClient()->get('', [
            'query' => [
                'function' => 'GLOBAL_QUOTE',
                'symbol' => $symbol,
                'apikey' => config('alphavantage.api_key'),
            ],
        ]);

        $globalQuote = Arr::get(json_decode($response->getBody()->getContents(), true), 'Global Quote');

        if (empty($globalQuote)) {
            return null;
        }

        return [
            'symbol' => Arr::get($globalQuote, '01. symbol'),
            'open' => (float) Arr::get($globalQuote, '02. open'),
            'high' => (float) Arr::get($globalQuote, '03. high'),
            'low' => (float) Arr::get($globalQuote, '04. low'),
            'price' => (float) Arr::get($globalQuote, '05. price'),
            'volume' => (float) Arr::get($globalQuote, '06. volume'),
            'latest trading day' => Arr::get($globalQuote, '07. latest trading day'),
            'previous close' => (float) Arr::get($globalQuote, '08. previous close'),
            'change' => (float) Arr::get($globalQuote, '09. change'),
            'change percent' => (float) Arr::get($globalQuote, '10. change percent'),
        ];
    }
}
