<?php

declare(strict_types=1);

namespace Inside\Content\Services\Revision\Widget;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;

class SelectWidget extends AbstractWidget implements Widget
{
    public function toFrontView(): array
    {
        $value = $this->content->{Str::camel($this->fieldName)};
        if ($value instanceof Collection) {
            $target = Arr::first($this->options['target'] ?? ['news']);
            $value = $target == 'users'
                ? $value->map(fn (Users $user) => inside_user_fullname($user))
                : $value->pluck('title');
        }
        if ($this->options['cardinality'] === 1) {
            $value = is_array($value) ? Arr::first($value) : $value;
        }

        return $this->prepareFrontDataWithValue($value);
    }

    public function toBridgeContentData(): mixed
    {
        $values = $this->content->{Str::camel($this->fieldName)};
        if (is_string($values)) {
            if ($this->options['cardinality'] === 1) {
                return $values;
            }
            $values = collect([$values]);
        }
        $values = $values?->pluck('uuid')->toArray();
        if ($this->options['cardinality'] === 1) {
            return is_array($values) ? Arr::first($values) : null;
        }

        return $values;
    }
}
