<?php

declare(strict_types=1);

namespace Inside\Content\Services\Revision\Widget;

use Illuminate\Support\Facades\App;
use Inside\Content\Contracts\RevisionService;
use Inside\Content\Models\Content;
use Inside\Content\Models\Revision;
use Inside\Content\Models\Section;

abstract class AbstractWidget
{
    public function __construct(
        protected RevisionService $revisionService,
        protected Content|Section $content,
        protected Revision $revision,
        protected string $fieldName,
        protected array $options = [],
        protected ?string $locale = null,
        protected ?Content $root = null
    ) {
        if (is_null($locale)) {
            $this->locale = App::getLocale();
        }
    }

    protected function getLocale(): string
    {
        if (is_null($this->locale)) {
            return config('app.locale', 'fr');
        }

        return $this->locale;
    }

    protected function getValue(): mixed
    {
        return $this->content->{$this->fieldName};
    }

    protected function prepareFrontDataWithValue(mixed $value): array
    {
        return [
            'type' => $this->options['widget'],
            'label' => $this->options['title'][$this->getLocale()] ?? '',
            'value' => $value,
        ];
    }
}
