<?php

namespace Inside\Content\Services\Importers;

use Inside\Content\Events\ImportCompletedEvent;
use Maatwebsite\Excel\Excel;
use Symfony\Component\Console\Output\OutputInterface;

class ExcelImporter extends AbstractImporter
{
    protected string $format = Excel::XLS;

    public function import(array $config, OutputInterface $console = null): bool
    {
        $preFlight = $config['preFlight'] ?? null;
        if ($preFlight && is_callable($preFlight)) {
            $preFlight($console);
        }

        if ($console) {
            (new ContentImport($config))->withOutput($console)->import($config['file']);
        } else {
            if ($config['driver'] === 'xls') {
                (new ContentImport($config))->import($config['file']);
                event(new ImportCompletedEvent($config, request()->user()));
            } else {
                (new ContentChunkedImport($config))->queue($config['file'])->allOnQueue(get_low_priority_queue_name())->chain(
                    [
                        new ImportCompletedEvent($config, request()->user()),
                    ]
                );
            }
        }

        $postFlight = $config['postFlight'] ?? null;
        if ($postFlight && is_callable($postFlight)) {
            $postFlight($console);
        }

        return true;
    }
}
