<?php

namespace Inside\Content\Services\Importers;

use Illuminate\Support\Str;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class AbstractImporter
 */
abstract class AbstractImporter implements ImporterInterface
{
    protected string $name;

    protected string $directoryPath = '';

    protected string $disk = 'protected';

    public function __construct()
    {
        $this->name = Str::lower(Str::before(get_class($this), 'Importer'));
    }

    public function getDirectoryPath(): string
    {
        return $this->directoryPath;
    }

    public function setDirectoryPath(string $directoryPath): void
    {
        $this->directoryPath = $directoryPath;
    }

    public function getName(): string
    {
        return $this->name;
    }

    abstract public function import(array $config, OutputInterface $console = null): bool;
}
