<?php

namespace Inside\Content\Services\Exporters;

use Dompdf\Dompdf;
use Maatwebsite\Excel\Excel;

/**
 * Class PdfExporter
 */
class PdfExporter extends ExcelExporter
{
    /** @var string */
    protected $extension = 'pdf';

    public function __construct()
    {
        parent::__construct();

        if (class_exists(Dompdf::class)) {
            $this->format = Excel::DOMPDF;
        } elseif (class_exists(\TCPDF::class)) {
            $this->format = Excel::TCPDF;
        } elseif (class_exists(\Mpdf\Mpdf::class)) {
            $this->format = Excel::MPDF;
        }
    }
}
