<?php

namespace Inside\Content\Services\Exporters;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Listeners\NotifyUserOfCompletedExport;
use Maatwebsite\Excel\Excel;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ExcelExporter
 */
class ExcelExporter extends AbastractExporter
{
    /** @var string */
    protected $format = Excel::XLS;

    /** @var string */
    protected $extension = 'xls';

    /**
     * @param array $config
     * @param OutputInterface|null $console
     * @return bool
     */
    public function export(array $config, OutputInterface $console = null): bool
    {
        $excelPath =
            $this->directoryPath.now()->format('YmdHis').'_'.Str::random(8).'_export.'.$this->extension;

        $notifications = [];
        if (request()->user()) {
            $notifications[] = new NotifyUserOfCompletedExport(request()->user(), $excelPath, $this->disk);
        }

        if ($console) {
            $console->writeln('Démarrage de l\'exportation');
            (new ContentExport($config))->store(
                $excelPath,
                $this->disk,
                $this->format
            );
            $console->writeln('Exportation terminée');
            $console->writeln('Retrouvez votre export ici ['.Storage::disk($this->disk)->path($excelPath).']');
        } else {
            (new ContentExport($config))->queue(
                $excelPath,
                $this->disk,
                $this->format
            )->chain(
                [
                    new NotifyUserOfCompletedExport(request()->user(), $excelPath, $this->disk),
                ]
            )->allOnQueue(get_low_priority_queue_name());
        }

        return true;
    }
}
