<?php

namespace Inside\Content\Services\Exporters;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class AbastractExporter
 */
abstract class AbastractExporter implements ExporterInterface
{
    protected string $name;

    protected string $directoryPath = '';

    protected string $disk = 'protected';

    public function __construct()
    {
        $this->name = Str::lower(Str::before(get_class($this), 'Exporter'));
    }

    public function getDirectoryPath(): string
    {
        return $this->directoryPath;
    }

    public function setDirectoryPath(string $directoryPath): void
    {
        $this->directoryPath = $directoryPath;
    }

    public function getName(): string
    {
        return $this->name;
    }

    abstract public function export(array $config, OutputInterface $console = null): bool;
}
