<?php

namespace Inside\Content\Services\ConfigurationGenerator\Traits;

use Illuminate\Support\Facades\DB;
use Inside\Support\Str;

trait WithUuid
{
    protected string $uuid;

    protected bool $created = false;

    protected function setUuid(): void
    {
        $config = DB::table('config')->where('name', $this->getName())->first();

        if ($config && property_exists($config, 'data')) {
            if (is_resource($config->data) && get_resource_type($config->data) === 'stream') {
                $config->data = stream_get_contents($config->data);
            }

            $this->uuid = Str::of($config->data)->after('"uuid";')->after('"')->before('"');
        } else {
            $this->uuid = Str::uuid();
            $this->created = true;
        }
    }

    public function isNew(): bool
    {
        return $this->created;
    }
}
