<?php

namespace Inside\Content\Services\ConfigurationGenerator\Traits;

use Illuminate\Support\Arr;

trait WithDottingSyntax
{
    public static function dot(string ...$values): string
    {
        return collect($values)->join('.');
    }

    public static function undot(array $array): array
    {
        $results = [];

        foreach ($array as $key => $value) {
            Arr::set($results, $key, $value);
        }

        return $results;
    }
}
