<?php

namespace Inside\Content\Services\ConfigurationGenerator;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\File;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class ConfigurationGenerator
{
    protected array $bundles;

    protected Collection $output;

    protected LanguageConfiguration $language;

    protected function __construct(array $configuration, array $bundles)
    {
        $this->bundles = $bundles;
        $this->language = LanguageConfiguration::load();
        $this->setOutputDirectory($configuration['output']);
    }

    protected function setOutputDirectory(string $path): void
    {
        File::ensureDirectoryExists($path);

        $output = collect([$this->language->getMain() => $path]);

        foreach ($this->language->getOthers() as $langcode) {
            File::ensureDirectoryExists($path.'/language/'.$langcode);
            $output->put($langcode, $path.'/language/'.$langcode);
        }

        $this->output = $output;
    }

    public static function load(array $bundles): self
    {
        return new self(config('generator.config'), $bundles);
    }

    public function generate(): void
    {
        collect($this->bundles)->each(fn (BaseBundle $bundle) => $this->generateBundle($bundle));
    }

    protected function generateBundle(BaseBundle $bundle): void
    {
        $filename = $bundle->getOutputYamlFilename();

        $this->generateFile(
            filename: $filename,
            langcode: $this->language->getMain(),
            content: $bundle->getOutputYaml($bundle->getOutputArray())
        );

        foreach ($bundle->getOutputTranslationsArray($this->language->getOthers()) as $langcode => $content) {
            $this->generateFile(
                filename: $filename,
                langcode: $langcode,
                content: $bundle->getOutputYaml($content)
            );
        }
    }

    protected function generateFile(string $filename, string $langcode, ?string $content): void
    {
        if (! empty($content)) {
            File::put($this->output->get($langcode).'/'.$filename, $content);
        }
    }
}
