<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class FileStorage extends BaseStorage
{
    public const Type = 'file';

    public const Module = 'file';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: array_merge([
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
            ], $configuration->get('storage.settings', []))
        );
    }
}
