<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class EntityReferenceRevisionsStorage extends BaseStorage
{
    public const Type = 'entity_reference_revisions';

    public const Module = 'entity_reference_revisions';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: array_merge([
                'target_type' => $configuration->get('target_type'),
            ], $configuration->get('storage.settings', []))
        );
    }
}
