<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class DateTimeStorage extends BaseStorage
{
    public const Type = 'datetime';

    public const Module = 'datetime';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: array_merge([
                'datetime_type' => 'datetime',
            ], $configuration->get('storage.settings', []))
        );
    }
}
