<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\TextWithSummaryStorage;

class TextWithSummaryField extends BaseField
{
    public const Storage = TextWithSummaryStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: array_merge([
                'display_summary' => false,
                'required_summary' => false,
            ], $configuration->get('field.settings', [])),
            defaultValue: $configuration->get('default_value', []),
            thirdPartySettings: $configuration->get('third_party_settings', []),
        );
    }
}
