<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\TextLongStorage;

class TextLongField extends BaseField
{
    public const Storage = TextLongStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: $configuration->get('field.settings', []),
            defaultValue: $configuration->get('default_value', []),
            thirdPartySettings: array_merge([
                'inside' => [
                    'search' => [
                        'searchable' => true,
                        'field_boost' => 1,
                    ],
                ],
            ], $configuration->get('third_party_settings', [])),
        );
    }
}
