<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\FileStorage;

class FileField extends BaseField
{
    public const Storage = FileStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: array_merge([
                'handler' => 'default:file',
                'handler_settings' => [],
                'file_directory' => '[date:custom:Y]-[date:custom:m]',
                'file_extensions' => config('generator.files.file_extensions'),
                'max_filesize' => config('generator.files.max_size'),
                'description_field' => false,
            ], $configuration->get('field.settings', [])),
            defaultValue: $configuration->get('default_value', []),
            thirdPartySettings: $configuration->get('third_party_settings', []),
        );
    }
}
