<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\CommentStorage;

class CommentField extends BaseField
{
    public const Storage = CommentStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: array_merge([
                'default_mode' => 1,
                'per_page' => 50,
                'anonymous' => 0,
                'form_location' => true,
                'preview' => 1,
            ], $configuration->get('field.settings', [])),
            defaultValue: array_merge([
                [
                    'status' => 2,
                    'cid' => 0,
                    'last_comment_timestamp' => 0,
                    'last_comment_name' => null,
                    'last_comment_uid' => 0,
                    'comment_count' => 0,
                    'default_value_callback' => '',
                ],
            ], $configuration->get('default_value', [])),
            thirdPartySettings: $configuration->get('third_party_settings', []),
        );
    }
}
