<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\BooleanStorage;

class BooleanField extends BaseField
{
    public const Storage = BooleanStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: array_merge([
                'on_label' => 'field.enable.label',
                'off_label' => 'field.disabled.label',
            ], $configuration->get('field.settings', [])),
            defaultValue: $configuration->get('default_value', [
                [
                    'value' => 0,
                ],
            ]),
            thirdPartySettings: $configuration->get('third_party_settings', []),
        );
    }
}
