<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle;

use Inside\Content\Services\ConfigurationGenerator\Traits\WithBaseYaml;
use Inside\Content\Services\ConfigurationGenerator\Traits\WithDottingSyntax;
use Inside\Content\Services\ConfigurationGenerator\Traits\WithOutputYaml;
use Inside\Content\Services\ConfigurationGenerator\Traits\WithTranslation;
use Inside\Content\Services\ConfigurationGenerator\Traits\WithUuid;

abstract class BaseBundle
{
    use WithBaseYaml;
    use WithDottingSyntax;
    use WithOutputYaml;
    use WithTranslation;
    use WithUuid;

    public const ContentEntityType = null;

    public const Bundle = null;

    public const Type = null;

    public const Module = null;

    protected function __construct()
    {
        $this->setUuid();
    }

    abstract protected function getName(): string;
}
