<?php

namespace Inside\Content\Services;

use Inside\Content\Models\Contents\AlphabetBooks;
use Inside\Content\Models\Contents\AlphabetBooksCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Support\Str;

class AlphabetContentService
{
    public static function assignToCategory(AlphabetBooks $model): void
    {
        $firstLetter = null;
        $title = trim(Str::ascii($model->title, 'en'));
        if (preg_match('/[A-Za-z]/u', $title, $matches)) {
            $firstLetter = strtoupper($matches[0]);
        }

        if (! $firstLetter || ! in_array($firstLetter, range('A', 'Z'))) {
            throw new \Exception('[AlphabetContentProcessor] first letter not valid as alphabet category !');
        }

        $alphabetCategory = AlphabetBooksCategories::query()
      ->where('langcode', $model->langcode)
      ->where('title', $firstLetter)
      ->firstOrFail();

        if ($alphabetCategory->is($model->alphabetBooksCategories?->first())) {
            return;
        }

        (new BridgeContent())->contentUpdate('alphabet_books', [
            'title' => $model->title,
            'uuid' => $model->uuid,
            'alphabet_books_categories' => $alphabetCategory->uuid,
            'content' => get_content_sections($model),
        ]);
    }
}
