<?php

namespace Inside\Content\Services\AdvancedTable;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class SectionDocumentTitleUpdater
{
    public static function updateAdvancedTables(string $documentUuid, $newDocumentTitle): void
    {
        $advancedTableDocuments = section_type_to_class('advanced_table')::query()->whereLike('advanced_table', "%$documentUuid%");
        $advancedTableDocuments->each(function ($document) use ($newDocumentTitle, $documentUuid) {
            $baseAdvancedTableSection = $resultSection = $document->advanced_table;
            $advancedTable = stripcslashes($baseAdvancedTableSection);

            preg_match_all('/<ged-documents\s+documents="([^"]+)">/', $advancedTable, $matches, PREG_SET_ORDER);

            foreach ($matches as $match) {
                $encodedJson = $match[1];

                if (Str::contains($encodedJson, rawurlencode($documentUuid))) {
                    $decodedArray = json_decode(urldecode($encodedJson), true);

                    foreach ($decodedArray as &$item) {
                        if ($item['uuid'] === $documentUuid) {
                            $item['title'] = $newDocumentTitle;
                        }
                    }

                    $newEncodedJson = rawurlencode(json_encode($decodedArray));

                    $resultSection = str_replace(
                        $encodedJson,
                        $newEncodedJson,
                        $baseAdvancedTableSection
                    );
                }
            }

            DB::table(section_type_to_table('advanced_table'))
                ->where('uuid', $document->uuid)
                ->update([
                    'advanced_table' => $resultSection,
                ]);
        });
    }
}
