<?php

namespace Inside\Content\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;
use Inside\Authentication\Models\User;

/**
 * Class PublishedScope
 *
 * hide contents that are not in date [published_at unpublished_at]
 */
class PublishedScope implements Scope
{
    /**
     * remove non publish contents
     *
     * @param  Builder  $builder
     * @param  Model  $model
     */
    public function apply(Builder $builder, Model $model)
    {
        if (! str_starts_with(get_class($model), 'Inside\\Content\\Models')
            && (
                ! Schema::hasColumn($model->getTable(), $model->getPublishedAtColumn()) ||
                ! Schema::hasColumn($model->getTable(), 'author')
            )
        ) {
            return;
        }

        /** @var User $user */
        $user = Auth::user();
        $builder->where(function ($query) use ($model, $user) {
            $query->where($model->getTable().'.author', $user->uuid)
                ->orWhere(function ($query) use ($model) {
                    $query->where(function ($query) use ($model) {
                        $query->where($model->getQualifiedPublishedAtColumn(), '<=', now())
                            ->orWhereNull($model->getQualifiedPublishedAtColumn());
                    })->when($model->hasUnpublishedAtColumn(), function ($query) use ($model) {
                        $query->where(function ($query) use ($model) {
                            $query->where($model->getQualifiedUnpublishedAtColumn(), '>=', now())
                                ->orWhereNull($model->getQualifiedUnpublishedAtColumn());
                        });
                    });
                });
        });
    }
}
