<?php

declare(strict_types=1);

namespace Inside\Content\Models\Traits;

use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Support\Facades\Event;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Events\ContentSavedWithImages;
use Inside\Content\Listeners\GenerateRevision;
use Inside\Content\Models\Revision;

trait Revisionable
{
    public static function bootRevisionable(): void
    {
        static::deleting(function (self $model) {
            $model->revisions->each->delete();
        });
        Event::listen(ContentFullyInsertedEvent::class, GenerateRevision::class);
        Event::listen(ContentFullyUpdatedEvent::class, GenerateRevision::class);
        Event::listen(ContentSavedWithImages::class, GenerateRevision::class);
    }

    public function revisions(): MorphMany
    {
        return $this->morphMany(Revision::class, 'contentable')
            ->orderByDesc('version');
    }

    public function getCurrentRevisionAttribute(): ?Revision
    {
        return $this->revisions()->first();
    }
}
