<?php

namespace Inside\Content\Models\Traits;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ScopeLogic;
use Inside\Content\Scopes\StatusScope;
use Inside\Permission\Facades\Permission;

/**
 * Trait HasStatus
 */
trait HasStatus
{
    /**
     * boot trait
     */
    public static function bootHasStatus(): void
    {
        if (App::runningInConsole()) {
            return;
        }
        $user = Auth::user();
        if (! $user instanceof User) {
            return;
        }

        if (ScopeLogic::statusScopeNeeded($user, class_to_type(get_called_class()))) {
            static::addGlobalScope(new StatusScope());
        }
    }

    public function initializeHasStatus(): void
    {
        if (! array_key_exists('status', $this->casts)) {
            $this->casts['status'] = 'boolean';
        }
    }
}
