<?php

declare(strict_types=1);

namespace Inside\Content\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Support\Facades\App;
use Inside\Authentication\Models\User;
use Inside\Content\Contracts\RevisionService;

/**
 * @property int $id
 * @property int $version
 * @property string $locale
 * @property string $data
 * @property string $contentable_id
 * @property string $contentable_type
 * @property-read Content $content
 * @property-read User|null $user
 * @property-read Carbon $created_at
 * @property-read Carbon $updated_at
 *
 * @mixin Builder
 */
final class Revision extends Model
{
    protected $guarded = [];

    protected $casts = [
        'revision' => 'integer',
    ];

    protected $hidden = [
        'data',
    ];

    protected $table = 'inside_revisions';

    public static function boot(): void
    {
        parent::boot();
        self::deleting(function (self $model) {
            App::make(RevisionService::class)->cleanupRevisionBeforeDeletion($model);
        });
    }

    public function content(): MorphTo
    {
        return $this->morphTo('contentable');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'uuid');
    }
}
