<?php

namespace Inside\Content\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * Inside\Content\Models\Pivot
 *
 * @property int $id
 * @property string $parent_uuid
 * @property string $related_uuid
 * @property int $weight
 * @property string $parent_type
 * @property string|null $parent_langcode
 * @property string $related_type
 * @property string|null $related_langcode
 * @property string $related_field
 * @property-read Model|\Eloquent $fromContent
 * @property-read Model|\Eloquent $toContent
 * @method static \Inside\Database\Eloquent\Builder|Pivot newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|Pivot newQuery()
 * @method static \Inside\Database\Eloquent\Builder|Pivot query()
 * @method static Builder|Pivot whereId($value)
 * @method static Builder|Pivot whereParentLangcode($value)
 * @method static Builder|Pivot whereParentType($value)
 * @method static Builder|Pivot whereParentUuid($value)
 * @method static Builder|Pivot whereRelatedField($value)
 * @method static Builder|Pivot whereRelatedLangcode($value)
 * @method static Builder|Pivot whereRelatedType($value)
 * @method static Builder|Pivot whereRelatedUuid($value)
 * @method static Builder|Pivot whereWeight($value)
 *
 * @mixin Builder
 */
class Pivot extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'inside_pivots';

    public function fromContent(): MorphTo
    {
        return $this->morphTo('parent', 'parent_type', 'parent_uuid');
    }

    public function toContent(): MorphTo
    {
        return $this->morphTo('related', 'related_type', 'related_uuid');
    }
}
