<?php

namespace Inside\Content\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model as BaseModel;

/**
 * @property int $id
 * @property int $model_id
 * @property string $class
 * @property array|null $options
 * @property string $model_options
 * @property string $field_options
 * @property int $field_id
 * @property string $type
 * @property int $displayed
 * @property-read \Illuminate\Database\Eloquent\Collection|\Inside\Content\Models\Field[] $fields
 * @property-read int|null $fields_count
 * @property-read mixed $model
 * @method static Builder|Model newModelQuery()
 * @method static Builder|Model newQuery()
 * @method static Builder|Model query()
 * @method static Builder|Model whereClass($value)
 * @method static Builder|Model whereId($value)
 * @method static Builder|Model whereOptions($value)
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @mixin Builder
 */
#[\AllowDynamicProperties]
class Model extends BaseModel
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_models';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $fillable = ['class', 'options'];

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that are hidden.
     *
     * @var array
     */
    protected $hidden = ['id'];

    /**
     * Remove the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * Fields to cast.
     *
     * @var array
     */
    protected $casts = [
        'options' => 'array',
    ];

    /**
     * Get associated fields
     */
    public function fields(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(Field::class);
    }

    /**
     * Old ambigus name
     *
     * @return mixed
     * @deprecated
     */
    public function getModelAttribute()
    {
        return $this->class;
    }

    /**
     * Get Model of front type $type
     *
     * @param $type
     *
     * @return Model
     */
    public static function ofType(string $type): self
    {
        $models = self::all();
        $result = $models->filter(
            function ($model) use ($type) {
                return isset($model->options['name']) && ($model->options['name'] === $type);
            }
        );
        if ($result->isEmpty()) {
            throw new \Illuminate\Database\Eloquent\ModelNotFoundException('Type ['.$type.'] not found');
        }

        return $result->first();
    }
}
