<?php

namespace Inside\Content\Listeners;

use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Inside\Content\Jobs\PublishContent;
use Inside\Content\Models\Content;

trait QueuePublishContent
{
    protected function queuePublishContent(Content $model): void
    {
        if (isset($model->published_at) && $model->status) { // Only publish content if status = 1
            $published_at = get_date($model->published_at)?->setSecond(0)?->setMicro(0);

            if ($published_at?->isFuture()) {
                Log::info(sprintf('[QueuePublishContent] %s - %s - Delayed publish at %s', $model->content_type, $model->uuid, $published_at->toDateTimeString()));
                if (config('queue.connections.lts', false)) {
                    PublishContent::dispatch($model)->delay($published_at)->onConnection('lts');
                } else {
                    PublishContent::dispatch($model)->delay($published_at);
                }
            } else {
                PublishContent::dispatch($model);
            }
        }
    }
}
