<?php

declare(strict_types=1);

namespace Inside\Content\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Contracts\WelcomeToTheJungleContentsManager;
use Inside\Content\Events\ContentDeletedEvent;

final class JobOffersDeletedListener implements ShouldQueue
{
    public function __construct(private WelcomeToTheJungleContentsManager $welcomeToTheJungleContentsManager)
    {
    }

    public function handle(ContentDeletedEvent $event): void
    {
        $model = $event->model;

        if ($this->welcomeToTheJungleContentsManager->isWTTJEnabled() && $model?->content_type === 'job_offers') {
            $this->welcomeToTheJungleContentsManager->deleteOrphanJobOffersApplicationForms();
        }
    }
}
