<?php

declare(strict_types=1);

namespace Inside\Content\Listeners;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Services\AdvancedTable\SectionDocumentTitleUpdater;

class DocumentTitleUpdatedListener
{
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;
        $uuid = $model->uuid;

        if ($model->content_type !== 'documents' || ! $model->isDirty('title')) {
            return;
        }

        SectionDocumentTitleUpdater::updateAdvancedTables($uuid, $model->title);
    }
}
