<?php

namespace Inside\Content\Listeners;

use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Inside\Content\Events\ContentPublishedEvent;

/**
 * Content published listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentPublishedListener extends BaseContentListener
{
    /**
     * @inheritDoc
     */
    public function handle(ContentPublishedEvent $event): void
    {
        $model = $event->model;

        // On publishing, we need to clear content cache
        $this->forgetCache($model);
    }
}
