<?php

namespace Inside\Content\Jobs;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Mail\ContentReported;
use Inside\Jobs\Job;
use Inside\Permission\Models\Role;

class ReportContent extends Job
{
    public function __construct(
        protected string $contentType,
        protected string $contentUuid,
        protected string $reason,
        protected User $reporter
    ) {
    }

    public function handle(): void
    {
        $content = ContentHelper::find($this->contentType, $this->contentUuid);
        if (is_null($content)) {
            return;
        }

        $roles = config('report.roles', ['super_administrator']);

        foreach ($roles as $roleName) {
            /** @var Role|null $role */
            $role = Role::where('name', $roleName)->first();
            if (is_null($role)) {
                continue;
            }

            foreach ($role->users->where('id', '<>', $this->reporter->uuid) as $user) {
                try {
                    Mail::to($user->email)->send(new ContentReported($user, $content, $this->reason, $this->reporter));
                } catch (\Exception $e) {
                    Log::error($e->getMessage());

                    continue;
                }
            }
        }
    }
}
