<?php

declare(strict_types=1);

namespace Inside\Content\Jobs;

use Illuminate\Support\Facades\Log;
use Inside\Content\Contracts\RevisionService;
use Inside\Content\Models\Content;
use Inside\Jobs\Job;

final class InitRevisionForContent extends Job
{
    public function __construct(
        protected Content $content
    ) {
    }

    public function handle(RevisionService $revisionService): void
    {
        Log::debug(__(
            '[InitRevisionForContent] Creating first version for content :type<:uuid>',
            [
                'type' => $this->content->content_type,
                'uuid' => $this->content->uuid ?? 'null',
            ]
        ));
        $revisionService->createNewRevision($this->content);
    }
}
