<?php

namespace Inside\Content\Http\Controllers;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\UploadedFile;
use Inside\Content\Contracts\WysiwygImageService;
use Inside\Content\Http\Requests\WysiwygImageStoreRequest;
use Inside\Content\Models\WysiwygImage;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class WysiwygImageController extends Controller
{
    public function store(WysiwygImageStoreRequest $request, WysiwygImageService $service): JsonResponse
    {
        /** @var UploadedFile $file */
        $file = $request->file('image');

        return response()->json([
            'url' => $service->upload($file, $request->get('path', '/')),
        ]);
    }

    public function serve(WysiwygImageService $service, string $path): BinaryFileResponse
    {
        $image = $service->load($path);
        if (is_null($image) || md5_file($image->path) != $image->hash) {
            throw (new ModelNotFoundException())->setModel(WysiwygImage::class);
        }

        return new BinaryFileResponse($image->path, 200, ['Content-Type' => $image->mimetype]);
    }
}
