<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers\Revision;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\File;
use Inside\Content\Contracts\RevisionService;
use Laravel\Lumen\Routing\Controller as BaseController;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

final class ServeFile extends BaseController
{
    public function __invoke(
        RevisionService $service,
        string $type,
        string $uuid,
        int $version,
        string $path
    ): BinaryFileResponse {
        $file = $service->findRevisionFile($type, $uuid, $version, $path);
        if (is_null($file)) {
            throw (new ModelNotFoundException())->setModel('file');
        }

        return new BinaryFileResponse($file, 200, ['Content-Type' => File::mimeType($file)]);
    }
}
