<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers\Revision;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Contracts\RevisionService;
use Inside\Content\Models\Revision;
use Inside\Content\Models\WysiwygImage;
use Laravel\Lumen\Routing\Controller as BaseController;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

final class Serve extends BaseController
{
    public function __invoke(
        RevisionService $service,
        string $type,
        string $uuid,
        int $version,
        string $path
    ): BinaryFileResponse {
        $image = $service->findRevisionImage($type, $uuid, $version, $path);
        if (is_null($image) || ! isset($image->revision_path)) {
            throw (new ModelNotFoundException())->setModel(WysiwygImage::class);
        }

        return new BinaryFileResponse($image->revision_path, 200, ['Content-Type' => $image->mimetype]);
    }
}
