<?php

namespace Inside\Content\Http\Controllers\Resource;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

final class ServeProtected extends Controller
{
    public function __invoke(string $path): BinaryFileResponse
    {
        $me = Auth::user();

        // protected resource means at least be connected
        if (is_null($me)) {
            throw new ModelNotFoundException();
        }

        // Url decode path
        $path = urldecode($path);

        $customPermissions = config('permission.custom_protected_resource_permissions', []);

        foreach ($customPermissions as $customPermission) {
            if ($customPermission && is_callable($customPermission)) {
                if ($customPermission($path) === false) {
                    throw new ModelNotFoundException();
                }
            }
        }

        $disk = Storage::disk('protected');

        $headers = [];
        if ($disk->mimeType($path) == 'application/pdf') {
            $headers['Accept-Ranges'] = 'none';
        }

        return new BinaryFileResponse($disk->path($path), 200, $headers);
    }
}
