<?php

namespace Inside\Content\Http\Controllers\Resource;

use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

final class ServeForDev extends Controller
{
    public function __invoke(string $apiToken, string $slug, string $path): Response
    {
        if (config('app.debug', false) === false) {
            abort(500);
        }
        // Check token is valid
        request()->headers->set('api-token', $apiToken);
        if (Auth::guest()) {
            abort(401);
        }

        return (new Serve)($slug, $path);
    }
}
