<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers\Permissions;

use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Content;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

final class Can extends Controller
{
    public function __invoke(string $contentType, string $uuid, string $action): JsonResponse
    {
        if (! Schema::hasModel($contentType)) {
            throw new BadRequestHttpException("$contentType is not a valid contentType");
        }

        $content = type_to_class($contentType)::find($uuid);

        if (! $content instanceof Content) {
            throw new NotFoundHttpException("$contentType of uuid $uuid not found");
        }

        /** @var User $user */
        $user = Auth::user();

        return response()->json(['result' => $user->can($action, $content)]);
    }
}
